<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('penilaian_guru', function (Blueprint $table) {
            $table->id();
            $table->foreignId('distribusi_instrumen_id')->constrained('distribusi_instrumen')->onDelete('cascade');
            $table->foreignId('guru_id')->constrained('guru')->onDelete('cascade');
            $table->foreignId('kepala_id')->constrained('users')->onDelete('cascade');
            $table->enum('status', ['draft', 'submitted', 'revision', 'validated'])->default('draft');
            $table->timestamp('tanggal_submit')->nullable();
            $table->timestamp('tanggal_validasi')->nullable();
            $table->decimal('total_nilai', 5, 2)->nullable();
            $table->decimal('rata_rata', 5, 2)->nullable();
            $table->text('catatan_kepala')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('penilaian_guru');
    }
};
