<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('distribusi_instrumen', function (Blueprint $table) {
            $table->id();
            $table->foreignId('instrumen_id')->constrained('instrumen')->onDelete('cascade');
            $table->foreignId('lembaga_id')->constrained('lembaga')->onDelete('cascade');
            $table->date('tanggal_distribusi');
            $table->date('deadline');
            $table->enum('status', ['active', 'closed'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('distribusi_instrumen');
    }
};
