<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('instrumen_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('instrumen_id')->constrained('instrumen')->onDelete('cascade');
            $table->integer('nomor_urut');
            $table->string('aspek_dimensi');
            $table->text('indikator');
            $table->text('sub_indikator')->nullable();
            $table->text('bukti_yang_diperlukan');
            $table->decimal('bobot', 3, 2)->default(1.00);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('instrumen_items');
    }
};
