<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guru', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('lembaga_id')->constrained('lembaga')->onDelete('cascade');
            $table->string('nip')->nullable();
            $table->string('nuptk')->nullable();
            $table->string('nama_lengkap');
            $table->string('gelar_depan')->nullable();
            $table->string('gelar_belakang')->nullable();
            $table->string('tempat_lahir');
            $table->date('tanggal_lahir');
            $table->enum('jenis_kelamin', ['L', 'P']);
            $table->string('pendidikan_terakhir');
            $table->string('jurusan')->nullable();
            $table->string('mata_pelajaran');
            $table->string('kelas_diampu');
            $table->enum('status_kepegawaian', ['PNS', 'PPPK', 'GTY', 'GTT']);
            $table->enum('status_sertifikasi', ['sudah', 'belum'])->default('belum');
            $table->year('tahun_sertifikasi')->nullable();
            $table->string('no_sertifikat')->nullable();
            $table->enum('status_inpassing', ['sudah', 'belum'])->default('belum');
            $table->string('golongan')->nullable();
            $table->date('tmt_golongan')->nullable();
            $table->text('alamat');
            $table->string('telepon')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guru');
    }
};
