<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\Notification;
use Illuminate\Support\Facades\Auth;

class NotificationViewComposerServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Share notifications (adapted: use pengawas role if needed)
        View::composer('*', function ($view) {
            if (Auth::check() && Auth::user()->hasRole('pengawas')) {
                $user = Auth::user();
                
                // Get notifications for this pengawas
                $notifications = Notification::with('related')
                    ->where('user_id', $user->id)
                    ->orderBy('created_at', 'desc')
                    ->limit(10)
                    ->get();

                // Get unread notification count
                $unreadCount = Notification::where('user_id', $user->id)
                    ->where('is_read', false)
                    ->count();

                $view->with([
                    'notifications' => $notifications,
                    'unreadCount' => $unreadCount
                ]);
            }
        });
    }
}
