<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ValidasiPengawas extends Model
{
    use HasFactory;

    protected $table = 'validasi_pengawas';

    protected $fillable = [
        'penilaian_kepala_id',
        'pengawas_id',
        'status',
        'feedback',
        'tanggal_validasi',
    ];

    protected $casts = [
        'tanggal_validasi' => 'datetime',
    ];

    // Relationships
    public function penilaianKepala()
    {
        return $this->belongsTo(PenilaianKepala::class);
    }

    public function pengawas()
    {
        return $this->belongsTo(User::class, 'pengawas_id');
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'penilaian_kepala_id' => 'required|exists:penilaian_kepala,id',
            'pengawas_id' => 'required|exists:users,id',
            'status' => 'required|in:approved,revision',
            'feedback' => 'nullable|string',
            'tanggal_validasi' => 'nullable|date',
        ];
    }
}
