<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'avatar',
        'foto_profil',
        'is_active',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function lembaga()
    {
        return $this->hasMany(Lembaga::class, 'pengawas_id');
    }

    public function lembagaKepala()
    {
        return $this->hasMany(Lembaga::class, 'kepala_id');
    }

    // Removed: guru() relation no longer used

    // Method instrumen() removed - instrumen no longer tied to specific pengawas
    // All instrumen are now universal and accessible to all pengawas

    public function penilaianSebagaiKepala()
    {
        return $this->hasMany(PenilaianKepala::class, 'kepala_id');
    }

    public function penilaianKepalaDibuat()
    {
        return $this->hasMany(PenilaianKepala::class, 'pengawas_id');
    }

    public function validasiPengawas()
    {
        return $this->hasMany(ValidasiPengawas::class, 'pengawas_id');
    }

    // Accessor untuk mendapatkan role utama user
    public function getRoleAttribute()
    {
        return $this->roles->first()?->name;
    }

    /**
     * Get the pengawas profile associated with the user
     */
    public function pengawas()
    {
        return $this->hasOne(Pengawas::class);
    }

    /**
     * Get the kepala profile associated with the user
     */
    public function kepala()
    {
        return $this->hasOne(Kepala::class);
    }
}
