<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubKomponen extends Model
{
    use HasFactory;

    protected $fillable = [
        'komponen_penilaian_id',
        'nama_sub_komponen',
        'deskripsi',
        'urutan',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function komponenPenilaian()
    {
        return $this->belongsTo(KomponenPenilaian::class);
    }

    public function instrumenPenilaians()
    {
        return $this->hasMany(InstrumenPenilaian::class)->orderBy('no_urutan');
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'nama_sub_komponen' => 'required|string|max:255',
            'deskripsi' => 'nullable|string',
            'urutan' => 'required|integer|min:1',
            'is_active' => 'boolean',
        ];
    }
}
