<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PenilaianKepala extends Model
{
    use HasFactory;

    protected $table = 'penilaian_kepala';

    protected $fillable = [
        'distribusi_instrumen_id',
        'kepala_id',
        'pengawas_id',
        'status',
        'tanggal_submit',
        'tanggal_validasi',
        'total_nilai',
        'rata_rata',
        'catatan_pengawas',
    ];

    protected $casts = [
        'tanggal_submit' => 'datetime',
        'tanggal_validasi' => 'datetime',
        'total_nilai' => 'decimal:2',
        'rata_rata' => 'decimal:2',
    ];

    public function distribusiInstrumen()
    {
        return $this->belongsTo(DistribusiInstrumen::class);
    }

    public function kepala()
    {
        return $this->belongsTo(User::class, 'kepala_id');
    }

    public function pengawas()
    {
        return $this->belongsTo(User::class, 'pengawas_id');
    }

    public function jawabanKepala()
    {
        return $this->hasMany(JawabanKepala::class);
    }
}


