<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PenilaianGuru extends Model
{
    use HasFactory;

    protected $table = 'penilaian_guru';

    protected $fillable = [
        'distribusi_instrumen_id',
        'guru_id',
        'kepala_id',
        'status',
        'tanggal_submit',
        'tanggal_validasi',
        'total_nilai',
        'rata_rata',
        'catatan_kepala',
    ];

    protected $casts = [
        'tanggal_submit' => 'datetime',
        'tanggal_validasi' => 'datetime',
        'total_nilai' => 'decimal:2',
        'rata_rata' => 'decimal:2',
    ];

    // Relationships
    public function distribusiInstrumen()
    {
        return $this->belongsTo(DistribusiInstrumen::class);
    }

    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    public function kepala()
    {
        return $this->belongsTo(User::class, 'kepala_id');
    }

    public function jawabanGuru()
    {
        return $this->hasMany(JawabanGuru::class);
    }

    public function validasiPengawas()
    {
        return $this->hasOne(ValidasiPengawas::class);
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'distribusi_instrumen_id' => 'required|exists:distribusi_instrumen,id',
            'guru_id' => 'required|exists:guru,id',
            'kepala_id' => 'required|exists:users,id',
            'status' => 'required|in:draft,submitted,revision,validated,final',
            'total_nilai' => 'nullable|numeric|min:0',
            'rata_rata' => 'nullable|numeric|min:0|max:5',
            'catatan_kepala' => 'nullable|string',
        ];
    }
}
