<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class KomponenPenilaian extends Model
{
    use HasFactory;

    protected $fillable = [
        'instrumen_id',
        'nama_komponen',
        'deskripsi',
        'urutan',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function instrumen()
    {
        return $this->belongsTo(Instrumen::class);
    }

    public function instrumenPenilaians()
    {
        return $this->hasMany(InstrumenPenilaian::class)->orderBy('no_urutan');
    }

    public function subKomponens()
    {
        return $this->hasMany(SubKomponen::class)->orderBy('urutan');
    }
}
