<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Kepala extends Model
{
    use HasFactory;

    protected $table = 'kepala';

    protected $fillable = [
        'user_id',
        'nip',
        'nuptk',
        'nama_lengkap',
        'gelar_depan',
        'gelar_belakang',
        'tempat_lahir',
        'tanggal_lahir',
        'jenis_kelamin',
        'pendidikan_terakhir',
        'jurusan',
        'alamat',
        'telepon',
    ];

    protected $casts = [
        'tanggal_lahir' => 'date',
    ];

    /**
     * Get the user that owns the kepala profile
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the lembaga that this kepala leads
     */
    public function lembaga(): HasMany
    {
        return $this->hasMany(Lembaga::class, 'kepala_id');
    }

    /**
     * Get the full name with titles
     */
    public function getNamaLengkapAttribute($value)
    {
        $nama = $value;
        if ($this->gelar_depan) {
            $nama = $this->gelar_depan . ' ' . $nama;
        }
        if ($this->gelar_belakang) {
            $nama = $nama . ', ' . $this->gelar_belakang;
        }
        return $nama;
    }

    /**
     * Get the age
     */
    public function getUmurAttribute()
    {
        return $this->tanggal_lahir ? $this->tanggal_lahir->age : null;
    }
}
