<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JawabanKepala extends Model
{
    use HasFactory;

    protected $table = 'jawaban_kepala';

    protected $fillable = [
        'penilaian_kepala_id',
        'instrumen_item_id',
        'url_bukti',
        'keterangan_bukti',
        'nilai_guru_self',
        'nilai_pengawas',
        'catatan_pengawas',
    ];

    public function penilaianKepala()
    {
        return $this->belongsTo(PenilaianKepala::class);
    }

    public function instrumenItem()
    {
        return $this->belongsTo(InstrumenPenilaian::class, 'instrumen_item_id');
    }
}


