<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JawabanGuru extends Model
{
    use HasFactory;

    protected $table = 'jawaban_guru';

    protected $fillable = [
        'penilaian_guru_id',
        'instrumen_item_id',
        'url_bukti',
        'keterangan_bukti',
        'nilai_guru_self',
        'nilai_kepala',
        'catatan_kepala',
    ];

    // Relationships
    public function penilaianGuru()
    {
        return $this->belongsTo(PenilaianGuru::class);
    }

    public function instrumenItem()
    {
        return $this->belongsTo(InstrumenPenilaian::class, 'instrumen_item_id');
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'penilaian_guru_id' => 'required|exists:penilaian_guru,id',
            'instrumen_item_id' => 'required|exists:instrumen_penilaians,id',
            'url_bukti' => 'nullable|url',
            'keterangan_bukti' => 'nullable|string',
            'nilai_guru_self' => 'nullable|integer|min:1|max:5',
            'nilai_kepala' => 'nullable|integer|min:1|max:5',
            'catatan_kepala' => 'nullable|string',
        ];
    }
}
