<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstrumenPenilaian extends Model
{
    use HasFactory;

    protected $fillable = [
        'komponen_penilaian_id',
        'sub_komponen_id',
        'no_urutan',
        'indikator_kinerja',
        'evidensi_kinerja',
        'skor_min',
        'skor_max',
        'bukti_url',
        'catatan_verifikasi',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function komponenPenilaian()
    {
        return $this->belongsTo(KomponenPenilaian::class);
    }

    public function subKomponen()
    {
        return $this->belongsTo(SubKomponen::class);
    }

    // Accessor untuk mendapatkan instrumen dari komponen
    public function getInstrumenAttribute()
    {
        return $this->komponenPenilaian->instrumen ?? null;
    }
}
