<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstrumenItem extends Model
{
    use HasFactory;

    protected $table = 'instrumen_items';

    protected $fillable = [
        'instrumen_id',
        'nomor_urut',
        'aspek_dimensi',
        'indikator',
        'sub_indikator',
        'bukti_yang_diperlukan',
        'bobot',
    ];

    // Accessors for compatibility with views
    public function getPertanyaanAttribute()
    {
        return $this->indikator;
    }

    public function getDeskripsiAttribute()
    {
        return $this->sub_indikator;
    }

    public function getUrutanAttribute()
    {
        return $this->nomor_urut;
    }

    protected $casts = [
        'bobot' => 'decimal:2',
    ];

    // Relationships
    public function instrumen()
    {
        return $this->belongsTo(Instrumen::class);
    }

    public function jawabanGuru()
    {
        return $this->hasMany(JawabanGuru::class);
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'instrumen_id' => 'required|exists:instrumen,id',
            'nomor_urut' => 'required|integer|min:1',
            'aspek_dimensi' => 'required|string|max:100',
            'indikator' => 'required|string',
            'sub_indikator' => 'nullable|string',
            'bukti_yang_diperlukan' => 'required|string',
            'bobot' => 'required|numeric|min:0|max:10',
        ];
    }
}
