<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Instrumen extends Model
{
    use HasFactory;

    protected $table = 'instrumen';

    protected $fillable = [
        'judul',
        'deskripsi',
        'tahun_ajaran',
        'semester',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships - Instrumen sekarang tidak terikat ke pengawas spesifik

    public function instrumenItems()
    {
        return $this->hasMany(InstrumenItem::class);
    }

    public function distribusiInstrumen()
    {
        return $this->hasMany(DistribusiInstrumen::class);
    }

    public function komponenPenilaians()
    {
        return $this->hasMany(KomponenPenilaian::class)->orderBy('urutan');
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'judul' => 'required|string|max:255',
            'deskripsi' => 'nullable|string',
            'tahun_ajaran' => 'required|string|max:20',
            'semester' => 'required|in:1,2',
            'is_active' => 'boolean',
        ];
    }
}
