<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DistribusiInstrumen extends Model
{
    use HasFactory;

    protected $table = 'distribusi_instrumen';

    protected $fillable = [
        'instrumen_id',
        'komponen_id',
        'lembaga_id',
        'tanggal_distribusi',
        'deadline',
        'status',
        'jenis_distribusi',
    ];

    protected $casts = [
        'tanggal_distribusi' => 'date',
        'deadline' => 'date',
    ];

    // Relationships
    public function instrumen()
    {
        return $this->belongsTo(Instrumen::class);
    }

    public function komponen()
    {
        return $this->belongsTo(KomponenPenilaian::class, 'komponen_id');
    }

    public function lembaga()
    {
        return $this->belongsTo(Lembaga::class);
    }

    public function penilaianKepala()
    {
        return $this->hasMany(PenilaianKepala::class);
    }

    // Validation rules
    public static function validationRules($id = null)
    {
        return [
            'instrumen_id' => 'required|exists:instrumen,id',
            'lembaga_id' => 'required|exists:lembaga,id',
            'tanggal_distribusi' => 'required|date',
            'deadline' => 'required|date|after:tanggal_distribusi',
            'status' => 'required|in:active,closed',
        ];
    }
}
