<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppSettings extends Model
{
    use HasFactory;

    protected $table = 'app_settings';
    
    protected $fillable = [
        'app_name',
        'app_logo',
        'app_favicon',
        'app_description',
        'app_version',
        'app_author',
        'app_email',
        'app_phone',
        'app_address',
        'app_website',
        'app_timezone',
        'app_locale',
        'app_pagination',
        'app_maintenance',
        'maintenance_message',
        'app_notifications',
        'app_logs',
        'backup_frequency',
        'backup_retention',
        'gemini_api_key',
        'gemini_model',
        'gemini_enabled',
        'gemini_max_tokens',
        'gemini_temperature'
    ];

    protected $casts = [
        'app_maintenance' => 'boolean',
        'app_notifications' => 'boolean',
        'app_logs' => 'boolean',
        'app_pagination' => 'integer',
        'backup_retention' => 'integer',
        'gemini_enabled' => 'boolean',
        'gemini_max_tokens' => 'integer',
        'gemini_temperature' => 'decimal:2'
    ];

    /**
     * Get the first (and only) settings record
     */
    public static function getSettings()
    {
        return static::first() ?? static::create([
            'app_name' => 'Sistem Penilaian Kinerja Guru',
            'app_version' => '1.0.0',
            'app_timezone' => 'Asia/Jakarta',
            'app_locale' => 'id',
            'app_pagination' => 10,
            'app_maintenance' => false,
            'app_notifications' => true,
            'app_logs' => true,
            'backup_frequency' => 'daily',
            'backup_retention' => 30
        ]);
    }

    /**
     * Update settings
     */
    public static function updateSettings(array $data)
    {
        $settings = static::getSettings();
        $settings->update($data);
        return $settings;
    }
}