<?php

namespace App\Imports;

use App\Models\Lembaga;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\SkipsFailures;

class LembagaImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnFailure
{
    use Importable, SkipsFailures;

    public function model(array $row)
    {
        // Skip baris kosong
        if (empty($row['npsn_nsm']) || empty($row['nama_lembaga']) || empty($row['jenis'])) {
            return null;
        }

        return DB::transaction(function() use ($row) {
            return new Lembaga([
                'pengawas_id' => null, // Akan diisi nanti oleh pengawas
                'npsn_nsm' => trim($row['npsn_nsm']),
                'nama_lembaga' => trim($row['nama_lembaga']),
                'jenis' => strtoupper(trim($row['jenis'])), // Normalize to uppercase
                // Data lainnya akan dilengkapi nanti oleh kepala lembaga
                'alamat_lengkap' => '',
                'provinsi' => '',
                'kabupaten' => '',
                'kecamatan' => '',
                'kelurahan' => '',
                'kode_pos' => '',
                'telepon' => '',
                'email' => '',
                'website' => '',
                'nama_kepala' => '',
                'nip_kepala' => '',
                'akreditasi' => null,
                'tahun_berdiri' => null,
                'kepala_id' => null, // Akan diisi nanti ketika kepala mendaftar
            ]);
        });
    }

    public function rules(): array
    {
        return [
            '*.npsn_nsm' => ['nullable','string','unique:lembaga,npsn_nsm'],
            '*.nama_lembaga' => ['nullable','string'],
            '*.jenis' => ['nullable','in:RA,MI,MTs,MA,ra,mi,mts,ma,Ra,Mi,Mts,Ma'],
        ];
    }
}


