<?php

namespace App\Imports;

use App\Models\InstrumenPenilaian;
use App\Models\KomponenPenilaian;
use App\Models\SubKomponen;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;

class InstrumenPenilaianImport implements ToModel, WithHeadingRow, WithValidation, SkipsOnFailure
{
    use Importable, SkipsFailures;

    protected $komponenPenilaian;
    protected $subKomponen;
    private $rowCount = 0;

    public function __construct(KomponenPenilaian $komponenPenilaian, SubKomponen $subKomponen)
    {
        $this->komponenPenilaian = $komponenPenilaian;
        $this->subKomponen = $subKomponen;
    }

    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        // Skip baris kosong
        if (empty($row['no_urutan']) || empty($row['indikator_kinerja'])) {
            return null;
        }

        $this->rowCount++;

        return DB::transaction(function() use ($row) {
            return new InstrumenPenilaian([
                'komponen_penilaian_id' => $this->komponenPenilaian->id,
                'sub_komponen_id' => $this->subKomponen->id,
                'no_urutan' => (int) $row['no_urutan'],
                'indikator_kinerja' => trim($row['indikator_kinerja']),
                'evidensi_kinerja' => trim($row['evidensi_kinerja'] ?? ''),
                'skor_min' => (int) ($row['skor_min'] ?? 1),
                'skor_max' => (int) ($row['skor_max'] ?? 4),
                'bukti_url' => '', // Akan diisi oleh guru saat penilaian
                'catatan_verifikasi' => '', // Akan diisi oleh kepala saat verifikasi
                'is_active' => true,
            ]);
        });
    }

    /**
     * @return array
     */
    public function rules(): array
    {
        return [
            '*.no_urutan' => ['nullable','integer','min:1'],
            '*.indikator_kinerja' => ['nullable','string'],
            '*.evidensi_kinerja' => ['nullable','string'],
            '*.skor_min' => ['nullable','integer','min:1','max:4'],
            '*.skor_max' => ['nullable','integer','min:1','max:4'],
        ];
    }

    /**
     * Get the number of rows processed
     */
    public function getRowCount(): int
    {
        return $this->rowCount;
    }
}