<?php

namespace App\Http\Controllers;

use App\Exports\UsersTemplateExport;
use App\Imports\UsersImport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;

class TemplateController extends Controller
{
    /**
     * Download template Excel for import (public access)
     */
    public function downloadUsersTemplate()
    {
        try {
            $fileName = 'template_import_users_' . date('Y-m-d') . '.xlsx';
            
            return Excel::download(new UsersTemplateExport(), $fileName);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ], 500);
        }
    }

    /**
     * Show import form (public access)
     */
    public function showImportForm()
    {
        return view('public.import');
    }

    /**
     * Import users from Excel (public access)
     */
    public function importUsers(Request $request)
    {
        $request->validate([
            'file' => 'required|file|mimes:xlsx,xls,csv|max:2048'
        ]);

        try {
            $import = new UsersImport();
            Excel::import($import, $request->file('file'));
            
            $results = $import->getResults();
            
            $message = "Import berhasil! {$results['imported_count']} user berhasil diimport.";
            if (!empty($results['errors'])) {
                $message .= " Beberapa error: " . implode(', ', array_slice($results['errors'], 0, 3));
                if (count($results['errors']) > 3) {
                    $message .= " dan " . (count($results['errors']) - 3) . " error lainnya.";
                }
            }
            
            // Redirect ke admin users setelah import berhasil
            return redirect()->route('admin.users.index')
                ->with('success', $message);
                
        } catch (\Exception $e) {
            return redirect()->back()
                ->with('error', 'Terjadi kesalahan saat import: ' . $e->getMessage());
        }
    }
}
