<?php

namespace App\Http\Controllers\Pengawas;

use App\Http\Controllers\Controller;
use App\Models\Instrumen;
use App\Models\KomponenPenilaian;
use App\Models\SubKomponen;
use Illuminate\Http\Request;

class SubKomponenController extends Controller
{
    public function __construct()
    {
        $this->middleware('role:pengawas');
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Instrumen $instrumen, KomponenPenilaian $item)
    {
        $subKomponens = $item->subKomponens()->orderBy('urutan')->get();
        return view('pengawas.sub-komponen.index', compact('instrumen', 'item', 'subKomponens'));
    }

    /**
     * Display the specified resource.
     */
    public function show(Instrumen $instrumen, KomponenPenilaian $item, SubKomponen $subKomponen)
    {
        $subKomponen->load('instrumenPenilaians');
        return view('pengawas.sub-komponen.show', compact('instrumen', 'item', 'subKomponen'));
    }
}