<?php

namespace App\Http\Controllers\Pengawas;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Instrumen;
use App\Models\InstrumenItem;

class InstrumenItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(string $instrumenId)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        $items = $instrumen->komponenPenilaians()->with('instrumenPenilaians')->orderBy('urutan')->get();
        return view('pengawas.items.index', compact('instrumen', 'items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(string $instrumenId)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        return view('pengawas.items.create', compact('instrumen'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, string $instrumenId)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        // Pengawas tidak bisa membuat komponen, hanya admin yang bisa
        return redirect()->route('pengawas.instrumen.items.index', $instrumenId)
            ->with('error', 'Pengawas tidak dapat menambah komponen penilaian. Silakan hubungi admin.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $instrumenId, string $id)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        $item = $instrumen->komponenPenilaians()->with('instrumenPenilaians')->findOrFail($id);
        return view('pengawas.items.show', compact('instrumen', 'item'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $instrumenId, string $id)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        $item = $instrumen->komponenPenilaians()->with('instrumenPenilaians')->findOrFail($id);
        return view('pengawas.items.edit', compact('instrumen', 'item'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $instrumenId, string $id)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        // Pengawas tidak bisa mengedit komponen, hanya admin yang bisa
        return redirect()->route('pengawas.instrumen.items.index', $instrumenId)
            ->with('error', 'Pengawas tidak dapat mengedit komponen penilaian. Silakan hubungi admin.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $instrumenId, string $id)
    {
        $instrumen = Instrumen::findOrFail($instrumenId);
        // Pengawas tidak bisa menghapus komponen, hanya admin yang bisa
        return redirect()->route('pengawas.instrumen.items.index', $instrumenId)
            ->with('error', 'Pengawas tidak dapat menghapus komponen penilaian. Silakan hubungi admin.');
    }
}
