<?php

namespace App\Http\Controllers\Pengawas;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Instrumen;

class InstrumenController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $user = Auth::user();

        $query = Instrumen::withCount('komponenPenilaians');

        if ($request->filled('search')) {
            $search = $request->search;
            $query->where(function ($q) use ($search) {
                $q->where('judul', 'like', "%{$search}%")
                  ->orWhere('tahun_ajaran', 'like', "%{$search}%");
            });
        }

        if ($request->filled('semester')) {
            $query->where('semester', $request->semester);
        }

        $instrumen = $query->orderByDesc('id')->paginate(15);

        return view('pengawas.instrumen.index', compact('instrumen'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return redirect()->route('pengawas.instrumen.index')
            ->with('error', 'Pengawas tidak dapat membuat instrumen. Silakan hubungi admin.');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        return redirect()->route('pengawas.instrumen.index')
            ->with('error', 'Pengawas tidak dapat membuat instrumen. Silakan hubungi admin.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $instrumen = Instrumen::with([
            'komponenPenilaians.subKomponens.instrumenPenilaians'
        ])->findOrFail($id);
        return view('pengawas.instrumen.show', compact('instrumen'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        return redirect()->route('pengawas.instrumen.index')
            ->with('error', 'Pengawas tidak dapat mengedit instrumen. Silakan hubungi admin.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        return redirect()->route('pengawas.instrumen.index')
            ->with('error', 'Pengawas tidak dapat mengedit instrumen. Silakan hubungi admin.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        return redirect()->route('pengawas.instrumen.index')
            ->with('error', 'Pengawas tidak dapat menghapus instrumen. Silakan hubungi admin.');
    }
}
