<?php

namespace App\Http\Controllers\Pengawas;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Lembaga;
use App\Models\Instrumen;
use App\Models\DistribusiInstrumen;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $stats = [
            'total_lembaga' => Lembaga::where('pengawas_id', $user->id)->count(),
            'total_instrumen' => Instrumen::where('is_active', true)->count(),
            'total_distribusi' => DistribusiInstrumen::whereHas('lembaga', function($query) use ($user) {
                $query->where('pengawas_id', $user->id);
            })->count(),
            'lembaga_binaan' => Lembaga::where('pengawas_id', $user->id)->with('guru')->get(),
        ];

        return view('pengawas.dashboard', compact('stats'));
    }
}
