<?php

namespace App\Http\Controllers\Kepala;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\PenilaianKepala;

class PenilaianKepalaController extends Controller
{
    public function index()
    {
        $items = PenilaianKepala::with(['pengawas'])
            ->where('kepala_id', Auth::id())
            ->orderBy('created_at', 'desc')
            ->paginate(10);

        return view('kepala.penilaian_kepala.index', compact('items'));
    }

    public function show($id)
    {
        $penilaian = PenilaianKepala::with(['pengawas', 'jawabanKepala.instrumenItem'])
            ->where('kepala_id', Auth::id())
            ->findOrFail($id);

        return view('kepala.penilaian_kepala.show', compact('penilaian'));
    }
}


