<?php

namespace App\Http\Controllers\Kepala;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Guru;
use App\Models\DistribusiInstrumen;
use App\Models\PenilaianKepala;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $lembaga = $user->lembagaKepala()->first();
        
        if (!$lembaga) {
            return redirect()->route('login')
                ->with('error', 'Anda belum diassign ke lembaga manapun. Silakan hubungi admin.');
        }
        
        // Get stats for kepala's lembaga
        $stats = [
            'total_guru' => Guru::where('lembaga_id', $lembaga->id)->count(),
            'total_instrumen_distributed' => DistribusiInstrumen::where('lembaga_id', $lembaga->id)->count(),
            'total_penilaian' => PenilaianKepala::where('kepala_id', $user->id)->count(),
            'penilaian_by_status' => [
                'draft' => PenilaianKepala::where('kepala_id', $user->id)->where('status', 'draft')->count(),
                'submitted' => PenilaianKepala::where('kepala_id', $user->id)->where('status', 'submitted')->count(),
                'revision' => PenilaianKepala::where('kepala_id', $user->id)->where('status', 'revision')->count(),
                'validated' => PenilaianKepala::where('kepala_id', $user->id)->where('status', 'validated')->count(),
                'final' => PenilaianKepala::where('kepala_id', $user->id)->where('status', 'final')->count(),
            ]
        ];

        return view('kepala.dashboard', compact('stats', 'lembaga'));
    }
}
