<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user = Auth::user();
        
        // Debug log
        \Log::info('HomeController redirect for user: ' . $user->name . ' (ID: ' . $user->id . ')');
        \Log::info('User roles: ' . $user->roles->pluck('name')->implode(', '));
        
        // Redirect berdasarkan role
        if ($user->hasRole('admin')) {
            \Log::info('Redirecting to admin.dashboard');
            return redirect()->route('admin.dashboard');
        } elseif ($user->hasRole('pengawas')) {
            \Log::info('Redirecting to pengawas.dashboard');
            return redirect()->route('pengawas.dashboard');
        } elseif ($user->hasRole('kepala')) {
            \Log::info('Redirecting to kepala.dashboard');
            return redirect()->route('kepala.dashboard');
        }
        
        \Log::info('No role found, redirecting to login');
        return redirect()->route('login');
    }
}
