<?php

namespace App\Http\Controllers\Guru;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PenilaianGuru;
use Illuminate\Support\Facades\Auth;

class HasilController extends Controller
{
    /**
     * Display a listing of assessment results for the guru
     */
    public function index()
    {
        $user = Auth::user();
        $guru = $user->guru;
        
        if (!$guru) {
            return redirect()->route('guru.dashboard')
                ->with('error', 'Profil guru tidak ditemukan.');
        }

        // Get all penilaian for this guru
        $penilaianGuru = PenilaianGuru::with([
            'distribusiInstrumen.instrumen',
            'jawabanGuru.instrumenItem'
        ])
        ->where('guru_id', $guru->id)
        ->orderBy('created_at', 'desc')
        ->get();

        // Statistics
        $stats = [
            'total_penilaian' => $penilaianGuru->count(),
            'penilaian_by_status' => [
                'draft' => $penilaianGuru->where('status', 'draft')->count(),
                'submitted' => $penilaianGuru->where('status', 'submitted')->count(),
                'revision' => $penilaianGuru->where('status', 'revision')->count(),
                'validated' => $penilaianGuru->where('status', 'validated')->count(),
            ],
            'rata_rata_nilai' => $penilaianGuru->where('status', 'validated')->avg('rata_rata') ?? 0,
        ];

        return view('guru.hasil.index', compact('penilaianGuru', 'stats', 'guru'));
    }

    /**
     * Display specific assessment result
     */
    public function show($id)
    {
        $user = Auth::user();
        $guru = $user->guru;
        
        if (!$guru) {
            return redirect()->route('guru.dashboard')
                ->with('error', 'Profil guru tidak ditemukan.');
        }

        $penilaianGuru = PenilaianGuru::with([
            'distribusiInstrumen.instrumen.komponenPenilaians.instrumenPenilaians',
            'jawabanGuru.instrumenItem',
            'kepala'
        ])
        ->where('guru_id', $guru->id)
        ->findOrFail($id);

        return view('guru.hasil.show', compact('penilaianGuru', 'guru'));
    }
}
