<?php

namespace App\Http\Controllers\Guru;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DistribusiInstrumen;
use App\Models\PenilaianGuru;
use App\Models\JawabanGuru;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        
        $stats = [
            'total_instrumen_available' => DistribusiInstrumen::where('status', 'active')->count(),
            'total_penilaian' => PenilaianGuru::where('guru_id', $user->id)->count(),
            'penilaian_by_status' => [
                'draft' => PenilaianGuru::where('guru_id', $user->id)->where('status', 'draft')->count(),
                'submitted' => PenilaianGuru::where('guru_id', $user->id)->where('status', 'submitted')->count(),
                'validated' => PenilaianGuru::where('guru_id', $user->id)->where('status', 'validated')->count(),
            ],
            'recent_penilaian' => PenilaianGuru::where('guru_id', $user->id)
                ->with(['distribusiInstrumen.instrumen', 'jawabanGuru'])
                ->latest()
                ->limit(5)
                ->get()
        ];

        return view('guru.dashboard', compact('stats'));
    }
}
