<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Excel as ExcelWriter;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use App\Imports\LembagaImport;
use App\Exports\LembagaTemplateExport;

class LembagaImportController extends Controller
{
    public function template(): BinaryFileResponse
    {
        // Use Excel::download to return a BinaryFileResponse with correct .xlsx headers
        return Excel::download(new LembagaTemplateExport, 'template_lembaga.xlsx', ExcelWriter::XLSX);
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => ['required','mimes:xlsx','max:20480'],
        ]);

        try {
            $import = new LembagaImport;
            Excel::import($import, $request->file('file'));
            
            $importedCount = $import->getRowCount();
            $failedCount = $import->failures()->count();
            
            $message = "Import selesai. Berhasil: {$importedCount} lembaga";
            
            if ($failedCount > 0) {
                $message .= ", Gagal: {$failedCount} baris";
                
                // Tampilkan detail error
                $errorDetails = [];
                foreach ($import->failures() as $failure) {
                    $errorDetails[] = "Baris {$failure->row()}: " . implode(', ', $failure->errors());
                }
                $message .= ". Detail: " . implode('; ', $errorDetails);
            }
            
            return redirect()->route('admin.lembaga.index')->with('status', $message);
            
        } catch (\Throwable $e) {
            return back()->with('status', 'Import gagal: '.$e->getMessage());
        }
    }
}


