<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Instrumen;
use App\Models\KomponenPenilaian;
use Illuminate\Http\Request;

class KomponenPenilaianController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Instrumen $instrumen)
    {
        $komponenPenilaians = $instrumen->komponenPenilaians()->orderBy('urutan')->get();
        
        return view('admin.komponen-penilaian.index', compact('instrumen', 'komponenPenilaians'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Instrumen $instrumen)
    {
        return view('admin.komponen-penilaian.create', compact('instrumen'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, Instrumen $instrumen)
    {
        $request->validate([
            'nama_komponen' => 'required|string|max:255',
            'deskripsi' => 'nullable|string',
            'urutan' => 'required|integer|min:1',
            'is_active' => 'boolean',
        ]);

        $instrumen->komponenPenilaians()->create($request->all());

        return redirect()->route('admin.komponen-penilaian.index', $instrumen)
            ->with('status', 'Komponen penilaian berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(KomponenPenilaian $komponen)
    {
        return view('admin.komponen-penilaian.edit', compact('komponen'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, KomponenPenilaian $komponen)
    {
        $request->validate([
            'nama_komponen' => 'required|string|max:255',
            'deskripsi' => 'nullable|string',
            'urutan' => 'required|integer|min:1',
            'is_active' => 'boolean',
        ]);

        $komponen->update($request->all());

        return redirect()->route('admin.komponen-penilaian.index', $komponen->instrumen)
            ->with('status', 'Komponen penilaian berhasil diperbarui!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(KomponenPenilaian $komponen)
    {
        $instrumen = $komponen->instrumen;
        
        // Check if komponen has instrumen penilaian
        if ($komponen->instrumenPenilaians()->count() > 0) {
            return redirect()->route('admin.komponen-penilaian.index', $instrumen)
                ->with('error', 'Tidak dapat menghapus komponen yang masih memiliki instrumen penilaian!');
        }

        $komponen->delete();

        return redirect()->route('admin.komponen-penilaian.index', $instrumen)
            ->with('status', 'Komponen penilaian berhasil dihapus!');
    }
}
