<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\KomponenPenilaian;
use App\Models\SubKomponen;
use App\Models\InstrumenPenilaian;
use Illuminate\Http\Request;

class InstrumenPenilaianController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(KomponenPenilaian $komponen, SubKomponen $subKomponen)
    {
        $instrumenPenilaians = $subKomponen->instrumenPenilaians()->orderBy('no_urutan')->get();
        
        return view('admin.instrumen-penilaian.index', compact('komponen', 'subKomponen', 'instrumenPenilaians'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(KomponenPenilaian $komponen, SubKomponen $subKomponen)
    {
        return view('admin.instrumen-penilaian.create', compact('komponen', 'subKomponen'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, KomponenPenilaian $komponen, SubKomponen $subKomponen)
    {
        $request->validate([
            'no_urutan' => 'required|integer|min:1',
            'indikator_kinerja' => 'required|string',
            'evidensi_kinerja' => 'nullable|string',
            'skor_min' => 'required|integer|min:1|max:4',
            'skor_max' => 'required|integer|min:1|max:4|gte:skor_min',
            'bukti_url' => 'nullable|url',
            'catatan_verifikasi' => 'nullable|string',
            'is_active' => 'boolean',
        ]);

        $data = $request->all();
        $data['komponen_penilaian_id'] = $komponen->id;
        $data['sub_komponen_id'] = $subKomponen->id;

        InstrumenPenilaian::create($data);

        return redirect()->route('admin.instrumen-penilaian.index', ['komponen' => $komponen, 'subKomponen' => $subKomponen])
            ->with('status', 'Instrumen penilaian berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(InstrumenPenilaian $instrumenPenilaian)
    {
        $komponen = $instrumenPenilaian->komponenPenilaian;
        $subKomponen = $instrumenPenilaian->subKomponen;
        return view('admin.instrumen-penilaian.edit', compact('instrumenPenilaian', 'komponen', 'subKomponen'));
    }

    /**
     * Display the specified resource (modal detail via AJAX).
     */
    public function show(InstrumenPenilaian $instrumenPenilaian)
    {
        // Eager load relations if needed
        $instrumenPenilaian->load(['komponenPenilaian.instrumen', 'subKomponen']);
        return view('admin.instrumen-penilaian.detail', compact('instrumenPenilaian'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, InstrumenPenilaian $instrumenPenilaian)
    {
        $request->validate([
            'no_urutan' => 'required|integer|min:1',
            'indikator_kinerja' => 'required|string',
            'evidensi_kinerja' => 'nullable|string',
            'skor_min' => 'required|integer|min:1|max:4',
            'skor_max' => 'required|integer|min:1|max:4|gte:skor_min',
            'bukti_url' => 'nullable|url',
            'catatan_verifikasi' => 'nullable|string',
            'is_active' => 'boolean',
        ]);

        $instrumenPenilaian->update($request->all());

        return redirect()->route('admin.instrumen-penilaian.index', ['komponen' => $instrumenPenilaian->komponenPenilaian, 'subKomponen' => $instrumenPenilaian->subKomponen])
            ->with('status', 'Instrumen penilaian berhasil diperbarui!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(InstrumenPenilaian $instrumenPenilaian)
    {
        $komponen = $instrumenPenilaian->komponenPenilaian;
        $subKomponen = $instrumenPenilaian->subKomponen;
        $instrumenPenilaian->delete();

        return redirect()->route('admin.instrumen-penilaian.index', ['komponen' => $komponen, 'subKomponen' => $subKomponen])
            ->with('status', 'Instrumen penilaian berhasil dihapus!');
    }
}
