<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Lembaga;
use App\Models\Instrumen;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_users' => User::count(),
            'total_lembaga' => Lembaga::count(),
            'total_instrumen' => Instrumen::count(),
            'users_by_role' => [
                'admin' => User::role('admin')->count(),
                'pengawas' => User::role('pengawas')->count(),
                'kepala' => User::role('kepala')->count(),
            ]
        ];

        return view('admin.dashboard', compact('stats'));
    }
}
