<?php

namespace App\Helpers;

use App\Models\AppSettings;

class AppHelper
{
    /**
     * Get application settings
     */
    public static function getSettings()
    {
        return AppSettings::getSettings();
    }

    /**
     * Get application name
     */
    public static function getAppName()
    {
        return static::getSettings()->app_name ?? 'PKG System';
    }

    /**
     * Get application version
     */
    public static function getAppVersion()
    {
        return static::getSettings()->app_version ?? '1.0.0';
    }

    /**
     * Get application logo
     */
    public static function getAppLogo()
    {
        $settings = static::getSettings();
        if ($settings->app_logo) {
            return asset('storage/' . $settings->app_logo);
        }
        return 'https://adminlte.io/themes/v3/dist/img/AdminLTELogo.png';
    }

    /**
     * Get application favicon
     */
    public static function getAppFavicon()
    {
        $settings = static::getSettings();
        if ($settings->app_favicon) {
            return asset('storage/' . $settings->app_favicon);
        }
        return null;
    }
}
