<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class UsersTemplateExport implements FromCollection, WithHeadings, WithStyles, WithColumnWidths
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return collect([
            [
                'ID' => '',
                'Nama Lengkap' => 'John Doe',
                'Email' => 'john.doe@example.com',
                'Phone' => '081234567890',
                'Password' => 'password123',
                'Role' => 'guru',
                'Status' => 'Aktif'
            ],
            [
                'ID' => '',
                'Nama Lengkap' => 'Jane Smith',
                'Email' => 'jane.smith@example.com',
                'Phone' => '081234567891',
                'Password' => 'password123',
                'Role' => 'Pengawas',
                'Status' => 'AKTIF'
            ],
            [
                'ID' => '',
                'Nama Lengkap' => 'Admin User',
                'Email' => 'admin.user@example.com',
                'Phone' => '081234567892',
                'Password' => 'password123',
                'Role' => 'ADMIN',
                'Status' => 'aktif'
            ]
        ]);
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'ID',
            'Nama Lengkap',
            'Email',
            'Phone',
            'Password',
            'Role',
            'Status'
        ];
    }

    /**
     * @param Worksheet $sheet
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            1 => [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF']
                ],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '4472C4']
                ]
            ],
            2 => [
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'F2F2F2']
                ]
            ],
            3 => [
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'FFFFFF']
                ]
            ],
            4 => [
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'F2F2F2']
                ]
            ]
        ];
    }

    /**
     * @return array
     */
    public function columnWidths(): array
    {
        return [
            'A' => 8,   // ID
            'B' => 25,  // Nama Lengkap
            'C' => 30,  // Email
            'D' => 15,  // Phone
            'E' => 15,  // Password
            'F' => 12,  // Role
            'G' => 12,  // Status
        ];
    }
}
