<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class LembagaTemplateSheet implements FromArray, WithHeadings, WithTitle, WithStyles
{
    public function title(): string { return 'DATA_LEMBAGA'; }

    public function headings(): array
    {
        return [
            'npsn_nsm*',
            'nama_lembaga*',
            'jenis*',
        ];
    }

    public function array(): array
    {
        return [
            [
                '352510xxxx',
                'MA Contoh 1',
                'MA',
            ],
            [
                '352510yyyy',
                'MI Contoh 2',
                'MI',
            ],
            [
                '352510zzzz',
                'MTs Contoh 3',
                'MTs',
            ],
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->getStyle('A1:C1')->getFont()->setBold(true);
        $sheet->freezePane('A2');
        $sheet->getColumnDimension('A')->setWidth(20);
        $sheet->getColumnDimension('B')->setWidth(30);
        $sheet->getColumnDimension('C')->setWidth(15);
        return [];
    }
}


