<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class LembagaInstructionSheet implements FromArray, WithTitle, WithStyles
{
    public function title(): string { return 'PETUNJUK'; }

    public function array(): array
    {
        return [
            ['Template Import Lembaga - Petunjuk Pengisian'],
            ['Semua kolom WAJIB diisi. Data lengkap akan dilengkapi nanti oleh kepala lembaga.'],
            [''],
            ['Daftar kolom dan keterangan:'],
            ['1.', 'npsn_nsm*', 'NSM (Nomor Statistik Madrasah) - Wajib, harus unik.'],
            ['2.', 'nama_lembaga*', 'Nama resmi lembaga - Wajib diisi.'],
            ['3.', 'jenis*', 'Jenis lembaga: RA/MI/MTs/MA - Wajib diisi (tidak peka huruf besar-kecil).'],
            [''],
            ['Contoh pengisian:'],
            ['', 'npsn_nsm', 'nama_lembaga', 'jenis'],
            ['', '352510xxxx', 'MA Contoh 1', 'MA'],
            ['', '352510yyyy', 'MI Contoh 2', 'MI'],
            ['', '352510zzzz', 'MTs Contoh 3', 'MTs'],
            [''],
            ['Catatan:'],
            ['- Pastikan tidak ada baris kosong di tengah data.'],
            ['- Simpan sebagai .xlsx (Excel Workbook).'],
            ['- Disarankan uji coba 1-2 baris dulu sebelum bulk import.'],
            ['- Data lengkap (alamat, kepala, dll) akan dilengkapi nanti oleh kepala lembaga.'],
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $sheet->mergeCells('A1:C1');
        $sheet->getStyle('A1')->getFont()->setBold(true)->setSize(14);
        $sheet->getColumnDimension('A')->setWidth(6);
        $sheet->getColumnDimension('B')->setWidth(24);
        $sheet->getColumnDimension('C')->setWidth(90);
        return [];
    }
}


