<?php

namespace App\Exports;

use App\Models\KomponenPenilaian;
use App\Models\SubKomponen;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class InstrumenPenilaianTemplateSheet implements FromArray, WithHeadings, WithStyles, WithColumnWidths
{
    protected $komponenPenilaian;
    protected $subKomponen;

    public function __construct(KomponenPenilaian $komponenPenilaian, SubKomponen $subKomponen)
    {
        $this->komponenPenilaian = $komponenPenilaian;
        $this->subKomponen = $subKomponen;
    }

    /**
     * @return array
     */
    public function array(): array
    {
        return [
            // Contoh data
            [
                '1',
                'Guru menguasai karakteristik peserta didik dari aspek fisik, moral, spiritual, sosial, kultural, emosional, dan intelektual',
                'RPP yang menunjukkan analisis karakteristik peserta didik, catatan observasi peserta didik',
                '1',
                '4'
            ],
            [
                '2',
                'Guru menguasai teori belajar dan prinsip-prinsip pembelajaran yang mendidik',
                'RPP yang menunjukkan penerapan teori belajar, media pembelajaran yang sesuai',
                '1',
                '4'
            ],
        ];
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'no_urutan*',
            'indikator_kinerja*',
            'evidensi_kinerja',
            'skor_min*',
            'skor_max*',
        ];
    }

    /**
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            // Header row
            1 => [
                'font' => ['bold' => true],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'E3F2FD']
                ]
            ],
            // Merge cells for title
            'A1:E1' => [
                'font' => ['bold' => true, 'size' => 12],
                'alignment' => ['horizontal' => 'center'],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '2196F3']
                ]
            ],
        ];
    }

    /**
     * @return array
     */
    public function columnWidths(): array
    {
        return [
            'A' => 12,  // no_urutan
            'B' => 50,  // indikator_kinerja
            'C' => 40,  // evidensi_kinerja
            'D' => 12,  // skor_min
            'E' => 12,  // skor_max
        ];
    }
}
