<?php

namespace App\Exports;

use App\Models\KomponenPenilaian;
use App\Models\SubKomponen;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class InstrumenPenilaianTemplateExport implements WithMultipleSheets
{
    protected $komponenPenilaian;
    protected $subKomponen;

    public function __construct(KomponenPenilaian $komponenPenilaian, SubKomponen $subKomponen)
    {
        $this->komponenPenilaian = $komponenPenilaian;
        $this->subKomponen = $subKomponen;
    }

    /**
     * @return array
     */
    public function sheets(): array
    {
        return [
            new InstrumenPenilaianTemplateSheet($this->komponenPenilaian, $this->subKomponen),
            new InstrumenPenilaianInstructionSheet($this->komponenPenilaian, $this->subKomponen),
        ];
    }
}