<?php

namespace App\Exports;

use App\Models\KomponenPenilaian;
use App\Models\SubKomponen;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class InstrumenPenilaianInstructionSheet implements FromArray, WithStyles, WithColumnWidths
{
    protected $komponenPenilaian;
    protected $subKomponen;

    public function __construct(KomponenPenilaian $komponenPenilaian, SubKomponen $subKomponen)
    {
        $this->komponenPenilaian = $komponenPenilaian;
        $this->subKomponen = $subKomponen;
    }

    /**
     * @return array
     */
    public function array(): array
    {
        return [
            ['Template Import Instrumen Penilaian - Petunjuk Pengisian'],
            ['Komponen: ' . $this->komponenPenilaian->nama_komponen],
            ['Sub Komponen: ' . $this->subKomponen->nama_sub_komponen],
            ['Instrumen: ' . $this->komponenPenilaian->instrumen->judul],
            [''],
            ['Semua kolom bertanda (*) WAJIB diisi.'],
            [''],
            ['Daftar kolom dan keterangan:'],
            ['1.', 'no_urutan*', 'Nomor urut instrumen penilaian - Wajib, harus unik dalam sub komponen ini.'],
            ['2.', 'indikator_kinerja*', 'Indikator kinerja yang akan dinilai - Wajib diisi.'],
            ['3.', 'evidensi_kinerja', 'Bukti pendukung yang diperlukan - Opsional.'],
            ['4.', 'skor_min*', 'Skor minimum (1-4) - Wajib diisi.'],
            ['5.', 'skor_max*', 'Skor maksimum (1-4) - Wajib diisi, harus >= skor_min.'],
            [''],
            ['Contoh pengisian:'],
            ['', 'no_urutan', 'indikator_kinerja', 'evidensi_kinerja', 'skor_min', 'skor_max'],
            ['', '1', 'Guru menguasai karakteristik peserta didik', 'RPP, catatan observasi', '1', '4'],
            ['', '2', 'Guru menguasai teori belajar', 'RPP, media pembelajaran', '2', '4'],
            [''],
            ['Catatan:'],
            ['- Pastikan tidak ada baris kosong di tengah data.'],
            ['- Simpan sebagai .xlsx (Excel Workbook).'],
            ['- Disarankan uji coba 1-2 baris dulu sebelum bulk import.'],
            ['- Admin hanya membuat struktur instrumen penilaian.'],
            ['- Guru akan mengisi bukti URL saat proses penilaian.'],
            ['- Kepala akan mengisi catatan verifikasi saat verifikasi.'],
        ];
    }

    /**
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        return [
            // Title row
            1 => [
                'font' => ['bold' => true, 'size' => 14],
                'alignment' => ['horizontal' => 'center'],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '2196F3']
                ]
            ],
            // Info rows
            2 => ['font' => ['bold' => true]],
            3 => ['font' => ['bold' => true]],
            // Warning row
            5 => [
                'font' => ['bold' => true, 'color' => ['rgb' => 'FF0000']],
                'fill' => [
                    'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'FFF3E0']
                ]
            ],
            // Headers
            8 => ['font' => ['bold' => true]],
            17 => ['font' => ['bold' => true]],
            22 => ['font' => ['bold' => true]],
        ];
    }

    /**
     * @return array
     */
    public function columnWidths(): array
    {
        return [
            'A' => 5,   // Number
            'B' => 20,  // Column name
            'C' => 50,  // Description
            'D' => 30,  // Example 1
            'E' => 30,  // Example 2
            'F' => 30,  // Example 3
        ];
    }
}
