# Konfigurasi Gemini AI di Admin Settings

## Overview
Fitur ini menambahkan konfigurasi Gemini AI ke halaman pengaturan admin (`/admin/settings`) sehingga administrator dapat mengatur API key, model, dan parameter AI tanpa perlu mengedit file konfigurasi.

## Fitur yang Ditambahkan

### 1. Database Migration
- **File**: `database/migrations/2025_10_25_050458_add_gemini_api_settings_to_app_settings_table.php`
- **Fields yang ditambahkan**:
  - `gemini_api_key` (string, nullable)
  - `gemini_model` (string, default: 'gemini-pro')
  - `gemini_enabled` (boolean, default: false)
  - `gemini_max_tokens` (integer, default: 2048)
  - `gemini_temperature` (decimal, default: 0.70)

### 2. Model AppSettings Update
- **File**: `app/Models/AppSettings.php`
- Menambahkan field Gemini ke `$fillable` dan `$casts`
- Support untuk semua parameter Gemini AI

### 3. Settings Controller Update
- **File**: `app/Http/Controllers/Admin/SettingsController.php`
- **Method baru**: `updateGeminiSettings()`
- Validasi input untuk semua parameter Gemini
- Route: `POST /admin/settings/gemini`

### 4. AI Analysis Service Update
- **File**: `app/Services/AIAnalysisService.php`
- Menggunakan settings dari database instead of config file
- Method `isEnabled()` untuk check apakah AI aktif
- Dynamic API URL berdasarkan model yang dipilih
- Dynamic parameters (temperature, max_tokens) dari settings

### 5. Admin Settings View Update
- **File**: `resources/views/admin/settings/index.blade.php`
- Form konfigurasi Gemini AI dengan:
  - Toggle enable/disable
  - Input API key (password field)
  - Pilihan model (Gratis vs Pro)
  - Parameter max tokens dan temperature
  - Informasi lengkap tentang Gemini AI

## Konfigurasi yang Tersedia

### 1. Enable/Disable Gemini AI
- Toggle switch untuk mengaktifkan/menonaktifkan fitur AI
- Jika disabled, AI analysis akan return pesan default

### 2. API Key Configuration
- Input field untuk API key dari Google AI Studio
- Password field untuk keamanan
- Link ke Google AI Studio untuk mendapatkan API key

### 3. Model Selection
- **Gemini Pro (Gratis)**: 
  - Limit: 15 requests per menit
  - Cocok untuk penggunaan standar
- **Gemini Pro Vision (Pro)**:
  - Limit lebih tinggi
  - Fitur advanced
  - Berbayar

### 4. Advanced Parameters
- **Max Tokens**: 1-8192 (default: 2048)
- **Temperature**: 0-2 (default: 0.70)
  - 0 = Deterministic
  - 0.7 = Seimbang
  - 2 = Sangat kreatif

## Cara Menggunakan

### 1. Setup Gemini AI
1. Login sebagai admin
2. Akses `/admin/settings`
3. Scroll ke bagian "Pengaturan Gemini AI"
4. Aktifkan toggle "Aktifkan Gemini AI"
5. Masukkan API key dari Google AI Studio
6. Pilih model (Gratis atau Pro)
7. Atur parameter sesuai kebutuhan
8. Klik "Simpan Pengaturan Gemini AI"

### 2. Mendapatkan API Key
1. Kunjungi [Google AI Studio](https://makersuite.google.com/app/apikey)
2. Login dengan Google account
3. Klik "Create API Key"
4. Copy API key yang dihasilkan
5. Paste ke form settings

### 3. Testing
1. Setelah konfigurasi, test dengan:
   - Review penilaian guru sebagai kepala sekolah
   - Generate PDF raport
   - Cek apakah analisis AI muncul

## Error Handling

### 1. AI Disabled
- Jika AI disabled, akan return pesan: "Analisis AI tidak tersedia. Silakan hubungi administrator untuk mengaktifkan fitur ini."

### 2. API Key Invalid
- Error akan di-log ke Laravel log
- Fallback ke catatan manual

### 3. API Rate Limit
- Gemini Pro: 15 requests per menit
- Jika limit exceeded, akan return error message

## Security Considerations

### 1. API Key Storage
- API key disimpan di database
- Field password untuk keamanan input
- Tidak ditampilkan di interface

### 2. Access Control
- Hanya admin yang bisa mengakses settings
- Middleware `role:admin` protection

## File yang Dimodifikasi

### File Baru:
- `database/migrations/2025_10_25_050458_add_gemini_api_settings_to_app_settings_table.php`

### File yang Dimodifikasi:
- `app/Models/AppSettings.php`
- `app/Http/Controllers/Admin/SettingsController.php`
- `app/Services/AIAnalysisService.php`
- `resources/views/admin/settings/index.blade.php`
- `routes/web.php`

## Dependencies
- Google Gemini API
- Laravel HTTP Client (Guzzle)
- AdminLTE untuk UI

## Testing Checklist
- [ ] Migration berhasil dijalankan
- [ ] Form settings muncul di admin panel
- [ ] API key bisa disimpan dan diupdate
- [ ] Model selection berfungsi
- [ ] Parameter temperature dan max_tokens bisa diatur
- [ ] AI analysis berfungsi dengan settings baru
- [ ] Error handling untuk API key invalid
- [ ] Fallback message jika AI disabled
